// Traps and Doors //

function IsTrapOn(name, Trap_Frame)
{
	var Person_Frame = GetPersonFrame(name);
	if(Person_Frame == Trap_Frame) return true;
	else return false;
}

function UpdateTraps()
{
	var PX = Player.x;
	var PY = Player.y;
	for(var i = 0; i < 10; ++i) {
		///////////////////////////  Spike Trap //////////////////////////////
		if(DoesPersonExist("SpikeTrap_" + i)) {
			var x = GetPersonX("SpikeTrap_"+i), y = GetPersonY("SpikeTrap_"+i);
			if(PX == x && PY == y) {
				if(IsTrapOn("SpikeTrap_" + i, 1) && !Player.dieing ) DamagePlayer(5);
			}
		}
		///////////////////////////  Block Trap //////////////////////////////
		if(DoesPersonExist("BlockTrap_" + i)) {
			var x = GetPersonX("BlockTrap_"+i), y = GetPersonY("BlockTrap_"+i);
			if(PX == x && PY == y) {
				if(IsTrapOn("BlockTrap_" + i, 4) && !Player.dieing ) DamagePlayer(10);
			}
		}
	}
	if(Player.health == 0) { Player.death = true; PlayerDie(); }
}

function DamagePlayer(damage)
{
	Player.health -= damage;
	Player.dieing = true; 
}

var IgnoredDoors = []; 

function OpenDoor(num)
{
	SetPersonDirection("Door_" + num, "open");
	for (var i = 0; i < 31; ++i) QueuePersonCommand("Door_" + num, COMMAND_ANIMATE, false);
	IgnoredDoors.push("Door_" + num);
	SetPersonIgnoreList(Player.name, IgnoredDoors);
}

